/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class IDEASecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;

    public IDEASecretKey() {
        this.keyType_.setLongValue(Key.KeyType.IDEA);
    }

    protected IDEASecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.IDEA);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        IDEASecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        IDEASecretKey iDEASecretKey = (IDEASecretKey)super.clone();
        iDEASecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        IDEASecretKey.putAttributesInTable(iDEASecretKey);
        return iDEASecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof IDEASecretKey) {
            IDEASecretKey iDEASecretKey = (IDEASecretKey)object;
            bl = this == iDEASecretKey || super.equals(iDEASecretKey) && this.value_.equals(iDEASecretKey.value_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new IDEASecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    protected static void putAttributesInTable(IDEASecretKey iDEASecretKey) {
        if (iDEASecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        iDEASecretKey.attributeTable_.put(Attribute.VALUE, iDEASecretKey.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

